/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.skills;

import dev.toma.gunsrpg.api.common.attribute.IAttributeProvider;
import dev.toma.gunsrpg.api.common.skill.IClickableSkill;
import dev.toma.gunsrpg.api.common.skill.ICooldown;
import dev.toma.gunsrpg.api.common.skill.IDescriptionProvider;
import dev.toma.gunsrpg.common.attribute.Attribs;
import dev.toma.gunsrpg.common.capability.PlayerData;
import dev.toma.gunsrpg.common.entity.FlareEntity;
import dev.toma.gunsrpg.common.init.ModSounds;
import dev.toma.gunsrpg.common.skills.SimpleSkill;
import dev.toma.gunsrpg.common.skills.core.DescriptionContainer;
import dev.toma.gunsrpg.common.skills.core.SkillType;
import dev.toma.gunsrpg.util.Interval;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;

public class GodHelpUsSkill
extends SimpleSkill
implements ICooldown,
IClickableSkill,
IDescriptionProvider {
    private final DescriptionContainer container;
    private final int maxCooldown = Interval.hours(1).append(Interval.minutes(30)).valueIn(Interval.Unit.TICK);
    private int currentCooldown;

    public GodHelpUsSkill(SkillType<?> type) {
        super(type);
        this.container = new DescriptionContainer(type);
        this.container.addProperty("info", new Object[0]);
        this.container.addProperty("cooldown", Interval.format(this.maxCooldown, f -> f.src(Interval.Unit.TICK).out(Interval.Unit.HOUR, Interval.Unit.MINUTE)));
    }

    @Override
    public ITextComponent[] supplyDescription(int desiredLineCount) {
        return this.container.getLines();
    }

    @Override
    public boolean canApply(PlayerEntity user) {
        return this.currentCooldown == 0;
    }

    @Override
    public void onUse(PlayerEntity player) {
    }

    @Override
    public boolean canUse() {
        return this.currentCooldown <= 0;
    }

    @Override
    public void onSkillUsed(ServerPlayerEntity player) {
        this.currentCooldown = this.maxCooldown;
        player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), ModSounds.FLARE_SHOOT, SoundCategory.MASTER, 10.0f, 1.0f);
        player.field_70170_p.func_217376_c((Entity)new FlareEntity(player.field_70170_p, (PlayerEntity)player));
        PlayerData.get((PlayerEntity)player).ifPresent(data -> {
            IAttributeProvider provider = data.getAttributes();
            this.currentCooldown = (int)((double)this.currentCooldown * provider.getAttributeValue(Attribs.AIRDROP_CALL_COOLDOWN));
            data.sync(2);
        });
    }

    @Override
    public int getCooldown() {
        return this.currentCooldown;
    }

    @Override
    public void setOnCooldown() {
        this.currentCooldown = this.maxCooldown;
    }

    @Override
    public int getMaxCooldown() {
        return this.maxCooldown;
    }

    @Override
    public void onUpdate(PlayerEntity player) {
        if (this.currentCooldown > 0) {
            --this.currentCooldown;
        }
    }

    @Override
    public CompoundNBT saveData() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("cooldown", this.currentCooldown);
        return nbt;
    }

    @Override
    public void readData(CompoundNBT nbt) {
        this.currentCooldown = nbt.func_74762_e("cooldown");
    }
}

